library(MASS)
library(pscl)
library(cluster)
library(scatterplot3d)
library(msm)
library(tmvtnorm)
library(plyr)


set.seed(1234)

#Simualating data - 3 clusters with 150 observations per cluster, 3-dimensional data
nclust<-150
clust<-3
n<-nclust*clust

time<-sort(runif(n,1,50))
c1<-c2<-c3<-matrix(NA,nrow=nclust,ncol=3)

#Cluster 1#
beta_0<-matrix(c(1,1,1),nrow=nclust,ncol=3)
beta_1<-matrix(rep(c(1,1,0),nclust),byrow=T,ncol=3)
mu<-beta_0+(beta_1*time[1:nclust])

#Cluster 2#
beta_0<-matrix(c(3,3,3),nrow=nclust,ncol=3)
beta_1<-matrix(rep(c(0,0,0),nclust),byrow=T,ncol=3)
mu<-rbind(mu,beta_0+(beta_1*time[c((nclust+1):(nclust*2))]))

#Cluster 3 - X dimension associated with time#
beta_0<-matrix(c(5,5,5),nrow=nclust,ncol=3)
beta_1<-matrix(rep(c(0,0,0),nclust),byrow=T,ncol=3)
mu<-rbind(mu,(beta_0+(beta_1*time[c((nclust*2+1):(nclust*3))])))

data1=matrix(apply(mu,1,function (x) mvrnorm(1,x,diag(3)*0.15)),byrow=T,ncol=3)



#Creating data frame#
data1 <- data1
time1<-c(time)
original<- c(rep(1,nclust),rep(3,nclust),rep(5,nclust))
cluster <- as.numeric(c(rep(1,n)))
beta1_X <- c(rep(0.1,n))
beta1_Y <- c(rep(0.1,n))
beta1_Z <- c(rep(0.1,n))
beta0_X <- mean(data1[,1])
beta0_Y <- mean(data1[,2])
beta0_Z <- mean(data1[,3])

data.temp <- data.frame(data1,time1,original,cluster,beta0_X,beta0_Y,beta0_Z,beta1_X,beta1_Y,beta1_Z)
colnames(data.temp)<-c("X","Y","Z","time","original","cluster","beta0_X","beta0_Y","beta0_Z","beta1_X","beta1_Y","beta1_Z")
n<-nrow(data.temp)  


#####Algorithm Inputs#####
burn.in<-3000
working<-1500 + burn.in
final<-1000
nloops <-working+final
Dev<-loglike<-NULL
cluster_matrix <- matrix(0,ncol=n, nrow=n)
ls.cluster<-1000000000000000

##Parameters for Priors##
data=data.temp
alpha=0.01
sigma2<-matrix(c(0.1,0.1,0.1),nrow=nloops+1,ncol=3)###hyperprior parameter for error ###
	a<-0.001		###hyperprior parameter for error-scale###
	b<-0.001		###hyperprior parameter for error-shape###
mu_0<-matrix(rep(c(0,0,0,0,0,0),nloops+1),byrow=T,ncol=6)	###hyperprior parameters for beta0 and beta1###
	mu_0muhyper=c(0,0,0)
	mu_1muhyper=c(0,0,0)
	sigma2_0muhyper=1
	sigma2_1muhyper=1
sigma2_0<-matrix(c(rep(1,1)),nrow=nloops+1,ncol=6)		#####################################
	aa=0.001		###hyperprior parameter for error of base distribution-scale###
	bb=0.001		###hyperprior parameter for error of base distribution-shape###

I2 <- diag(6)
I <-diag(3)
m <- 3		#number of auxiliary parameters
'%ni%' <- Negate('%in%')
DIC<-c(rep(100000000,nloops+1))

combo<-data.frame(matrix(NA,nrow=m,ncol=7))
colnames(combo)<-c("beta0_X","beta0_Y","beta0_Z","beta1_X","beta1_Y","beta1_Z","Freq")
rownames(combo) <- c(paste("Aux",1:m,sep=''))


########Algorithm#######

for (x in 1:nloops){

	### Updating beta ###
	vars<-c(as.character(unlist(lapply(c('beta0','beta1'),function (zz) paste(zz,c("_X","_Y","_Z"),sep='')))))
	data.individual<-data[,c("X","Y","Z")]
	cluster.current<-data.frame(cbind(do.call("rbind", as.list(by(data[,vars],data$cluster,tail,n=1))),table(data$cluster)))[,-7]

	
	for (i in 1:n){
		if(any(cluster.current$Freq==0)==TRUE){cluster.current=cluster.current[-which(cluster.current$Freq==0),]}
		remove<-which(rownames(cluster.current) == data$cluster[i])
		cluster.current[remove,"Freq"]<-cluster.current[remove,"Freq"]-1
		colnames(combo)=colnames(cluster.current)

		phi_A <- matrix(rmvnorm(m,mu_0[x,], sigma2_0[x,]*I2), ncol=6,nrow=m)	
		combo[1:m,1:6]<-phi_A
		combo[1:m,7]<-(alpha/m)
		
		cluster.aux<-data.frame(rbind(cluster.current,combo))
		cluster.aux[,7]=cluster.aux[,7]/(n-1+alpha)
		max.cluster<-eval(1+max(data$cluster))
		prob<-apply(cluster.aux,1,function(g) g[7]*dmvnorm(data[i,1:3],c(g[1:3]+(g[4:6]*data[i,"time"])),sigma2[x,]*I))
		if(any(prob!=0)){prob=prob}else{prob[sample(1:length(prob),1)]=1}
		new_cluster <- rmultinom(1, 1, prob)
		inds = which(new_cluster == max(new_cluster), arr.ind=TRUE) 
		cluster_name = rownames(new_cluster)[inds[,1]]	
		rnames = rownames(new_cluster)[inds[,1]]	
		ind<-which(rownames(cluster.aux) == rnames)
			data[i,vars]=cluster.aux[ind,1:6]
			if(ind %ni% (nrow(cluster.aux)-(m-1)):nrow(cluster.aux)){data$cluster[i] <- as.numeric(rnames);
											     cluster.current[ind,7]<-cluster.current[ind,7]+1
			}else{rownames(cluster.aux)[ind]<-data$cluster[i]<-max.cluster;
				cluster.aux[ind,7]<-1;
				cluster.current<-rbind(cluster.current,cluster.aux[ind,]);
				rownames(cluster.current)<-c(rownames(cluster.current)[-nrow(cluster.current)],data$cluster[i])
			}	
	} 

 
	#Update unique betas_c #
	for(c in unique(data$cluster)){

		indc=which(data$cluster==c)
		n.c=length(indc)
		x.temp=matrix(c(rep(1,n.c),data[indc,'time']),nrow=n.c,ncol=2)
		beta.temp=matrix(c(as.numeric(data[indc,c('beta0_X','beta0_Y','beta0_Z')][1,]),as.numeric(data[indc,c('beta1_X','beta1_Y','beta1_Z')][1,])),byrow=T,ncol=3)
		y.temp=data[indc,c('X','Y','Z')]
		distance=y.temp-x.temp%*%beta.temp

		#Update beta0#
		part1=solve(sigma2[x,]*I)%*%colSums(y.temp-(x.temp[,2]%*%t(beta.temp[2,]))) + solve(sigma2_0[x,1:3]*I)%*%mu_0[x,1:3]
		part2=solve(solve(sigma2_0[x,1:3]*I) + n.c*solve(sigma2[x,]*I))
		data[indc,c('beta0_X','beta0_Y','beta0_Z')]=matrix(rep(rmvnorm(1,part2%*%part1,part2),each=n.c),byrow=F,ncol=3)

		#Update beta1#
		part1=solve(sigma2_0[x,4:6]*I)%*%mu_0[x,4:6]+solve(sigma2[x,]*I)%*%colSums((y.temp-data[indc,c('beta0_X','beta0_Y','beta0_Z')])*x.temp[,2])
		part2=solve(solve(sigma2_0[x,4:6]*I) + sum(x.temp[,2]^2)*solve(sigma2[x,]*I))
		data[indc,c('beta1_X','beta1_Y','beta1_Z')]=matrix(rep(rmvnorm(1,part2%*%part1,part2),each=n.c),byrow=F,ncol=3)	
	}


	###Update mu_0 for based distribution###
			part1=solve(sigma2_0muhyper*I)%*%mu_0muhyper + solve(sigma2_0[x,1:3]*I)%*%colSums(data[,c("beta0_X","beta0_Y","beta0_Z")])
			part2=solve(solve(sigma2_0muhyper*I) + n*solve(sigma2_0[x,1:3]*I))
		mu_0[x+1,1:3]=rmvnorm(1,part2%*%part1,part2)

			part1=solve(sigma2_1muhyper*I)%*%mu_1muhyper + solve(sigma2_0[x,4:6]*I)%*%colSums(data[,c("beta1_X","beta1_Y","beta1_Z")])
			part2=solve(solve(sigma2_1muhyper*I) + n*solve(sigma2_0[x,4:6]*I))
		mu_0[x+1,4:6]=rmvnorm(1,part2%*%part1,part2)


	###Update sigma2_0 for base distribution###
			distance2=data[,vars]-matrix(rep(mu_0[x+1,],n),byrow=T,ncol=6)
		sigma2_0[x+1,1]=rigamma(1,aa+(n/2),bb+(sum(distance2[,1]^2)/2))
		sigma2_0[x+1,2]=rigamma(1,aa+(n/2),bb+(sum(distance2[,2]^2)/2))
		sigma2_0[x+1,3]=rigamma(1,aa+(n/2),bb+(sum(distance2[,3]^2)/2))
		sigma2_0[x+1,4]=rigamma(1,aa+(n/2),bb+(sum(distance2[,4]^2)/2))
		sigma2_0[x+1,5]=rigamma(1,aa+(n/2),bb+(sum(distance2[,5]^2)/2))
		sigma2_0[x+1,6]=rigamma(1,aa+(n/2),bb+(sum(distance2[,6]^2)/2))


	###Update Sigma for error###			
			distance=data[,c('X','Y','Z')]-(data[,c('beta0_X','beta0_Y','beta0_Z')]+data[,c('beta1_X','beta1_Y','beta1_Z')]*data[,'time'])
		sigma2[x+1,1]<-rigamma(1,a+(n/2),b+(sum(distance[,1]^2)/2))
		sigma2[x+1,2]<-rigamma(1,a+(n/2),b+(sum(distance[,2]^2)/2))
		sigma2[x+1,3]<-rigamma(1,a+(n/2),b+(sum(distance[,3]^2)/2))
				
	
	###least squares clustering###
		#Updating clustering indicator Matrix#
		if(x >= burn.in & x < working){
			for(ind in unique(data$cluster)){
				matrix_indicator<-which(data$cluster == ind)
				cluster_matrix[matrix_indicator,matrix_indicator] <- cluster_matrix[matrix_indicator,matrix_indicator] + 1}
		}

		#Calculating the average probability matrix at the last Wth or working iteration#
		if(x == working){
			cluster_average<-cluster_matrix/{x-burn.in}
			best.distance=10000000
		}

		#F or final iterations#
		if(x >= working){
			cluster_matrix.temp<-matrix(0,nrow=n,ncol=n)

			for(ind in unique(data$cluster)){
				matrix_indicator<-which(data$cluster == ind)
				cluster_matrix.temp[matrix_indicator,matrix_indicator] <- cluster_matrix.temp[matrix_indicator,matrix_indicator] + 1
			}

			ls.distance<-sum({cluster_matrix.temp-cluster_average}*{cluster_matrix.temp-cluster_average})
			
			if(ls.distance <= best.distance){
			best.distance<-ls.distance
			cluster.data<-data
			updated.run<-x
			}
		}


	#DIC Calculations#
	if(x > burn.in){Dev<- c(Dev,-2*sum(log(apply(data,1,function (h) dmvnorm(h[1:3],h[9:11]+(h[12:14]*h[4]),sigma2[x+1,]*I))))
)}
	
cat("alpha",alpha," run",x,"\n")
}#end algorithm nloop

data.final<-cluster.data
data.final



		
